#include <bits/stdc++.h>
using namespace std;

const int ALPHABET_SIZE = 10;
const int N = 10005;
int dp[2][1025][ALPHABET_SIZE]; //dp[i][bitmask][lastDig]
int minOfMask[2][1025];

int a[N];
int n;

const int INF = 99999999;

void setDefs(){
    for(int i = 0; i < 2; ++i){
        for(int mask = 0; mask < (1 << ALPHABET_SIZE); ++mask){
            for(int j = 0; j < ALPHABET_SIZE; ++j){
                dp[i][mask][j] = INF;
                minOfMask[i][mask] = INF;
            }
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    {
        string str;
        cin >> str;
        n = str.size();
        for(int i = 0; i < n; ++i){
            a[i] = str[i] - '0';
        }
    }

    setDefs();

    for(int i = 0; i < ALPHABET_SIZE; ++i){
        int bit = (1 << i);
        dp[0][bit][i] = (i != a[0]);
        minOfMask[0][bit] = min(minOfMask[0][bit], dp[0][bit][i]);
    }

    for(int ind = 1; ind < n; ++ind){
        int i = (ind % 2);
        int li = (ind + 2 - 1) % 2;

        for(int mask = 1; mask < (1 << ALPHABET_SIZE); ++mask){ //this is the mask for i-1, il create a new mask for me.
            minOfMask[i][mask] = INF;
            for(int j = 0; j < ALPHABET_SIZE; ++j){
                int bit = (1 << j);
                if(!(bit & mask))
                    continue;

                int lmask = mask & (~bit);
                dp[i][mask][j] = min(dp[li][mask][j], minOfMask[li][lmask]) + (j != a[ind]);
                minOfMask[i][mask] = min(minOfMask[i][mask], dp[i][mask][j]);
            }
        }
    }

    int res = INT_MAX;
    int lastDp = (n - 1) % 2;
    for(int mask = 1; mask < (1 << ALPHABET_SIZE); ++mask){
        for(int j = 0; j < ALPHABET_SIZE; ++j){
            res = min(res, dp[lastDp][mask][j]);
        }
    }

    cout << res << "\n";
    return 0;
}

///10! = 3.628.800 = 3 * 10^6
///max range intersect = 10 * 10 = 100